// $Id: CLong.cpp,v 1.4 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CLong.hpp"
using Exponent::Basics::CLong;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CLong, CCountedObject);

//	===========================================================================
CLong::CLong(const long value) : m_value(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CLong);
	this->setValue(value);
}

//	===========================================================================
CLong::~CLong()
{
	EXPONENT_CLASS_DESTRUCTION(CLong);
}

//	===========================================================================
void CLong::setValue(const CLong &value)
{
	this->setValue(value.getValue());
}

//	===========================================================================
void CLong::setValue(const long value)
{
	m_value = value;
}

//	===========================================================================
long  CLong::getValue() const
{
	return m_value;
}

//	===========================================================================
CLong &CLong::operator = (const CLong &value)
{
	m_value = value.getValue();
	return (*this);
}

//	===========================================================================
CLong &CLong::operator = (const long value)
{
	m_value = value;
	return (*this);
}

//	===========================================================================
bool CLong::operator == (const CLong &value)
{
	return (m_value == value.getValue());
}

//	===========================================================================
bool CLong::operator == (const long value)
{
	return (m_value == value);
}

//	===========================================================================
bool CLong::operator != (const CLong &value)
{
	return (m_value != value.getValue());
}

//	===========================================================================
bool CLong::operator != (const long value)
{
	return (m_value != value);
}

//	===========================================================================
CLong &CLong::operator + (const CLong &value)
{
	m_value += value.getValue();
	return (*this);
}

//	===========================================================================
CLong &CLong::operator + (const long value)
{
	m_value += value;
	return (*this);
}

//	===========================================================================
CLong &CLong::operator - (const CLong &value)
{
	m_value -= value.getValue();
	return (*this);
}

//	===========================================================================
CLong &CLong::operator - (const long value)
{
	m_value -= value;
	return (*this);
}

//	===========================================================================
CLong &CLong::operator * (const CLong &value)
{
	m_value *= value.getValue();
	return (*this);
}

//	===========================================================================
CLong &CLong::operator * (const long value)
{
	m_value *= value;
	return (*this);
}

//	===========================================================================
CLong &CLong::operator / (const CLong &value)
{
	const long  val = value.getValue();
	if (val != 0)
	{
		m_value /= val;
	}
	else
	{
		m_value = 0;
	}
	return (*this);
}

//	===========================================================================
CLong &CLong::operator / (const long value)
{
	if (value != 0)
	{
		m_value /= value;
	}
	else
	{
		m_value = 0;
	}
	return (*this);
}

//	===========================================================================
CLong &CLong::operator += (const CLong &value)
{
	m_value += value.getValue();
	return (*this);
}

//	===========================================================================
CLong &CLong::operator += (const long value)
{
	m_value += value;
	return (*this);
}

//	===========================================================================
CLong &CLong::operator -= (const CLong &value)
{
	m_value -= value.getValue();
	return (*this);
}

//	===========================================================================
CLong &CLong::operator -= (const long value)
{
	m_value -= value;
	return (*this);
}

//	===========================================================================
bool CLong::operator ! ()
{
	return (m_value == 0);
}

//	===========================================================================
CString CLong::getValueAsString(const long preceedingZeros) const
{
	// STore the flag start
	char flag[256] = "%0";

	// Append the number of zeros
	char buffer[20];
	sprintf(buffer, "%li", preceedingZeros);

	// Copy the number to the buffer
	strcat(flag, buffer);
	strcat(flag, "li");

	// SEt the string
	CString string;
	string.setStringWithFormat(flag, m_value);

	// Return the stirng
	return string;

	/*
	char mod[256] = "%.0";
	char temp[20];
	sprintf(temp, "%li", decimalPlaces);
	strcat(mod, temp);
	strcat(mod, "d");
	char str[Exponent::Basics::CString::CSTRING_LONG_TEXT_LENGTH];
	sprintf(str, mod, m_value);
	return new CString(str);
	*/
}

//	===========================================================================
void CLong::getObjectDescription(char *string, const long size) const
{
	this->getValueAsString(2).getString(string, size);
}